/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.enchant;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import lotr.common.LOTRMod;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentType;
import lotr.common.item.LOTRItemArmor;
import lotr.common.item.LOTRItemAxe;
import lotr.common.item.LOTRItemBow;
import lotr.common.item.LOTRItemCrossbow;
import lotr.common.item.LOTRItemHobbitPipe;
import lotr.common.item.LOTRItemHoe;
import lotr.common.item.LOTRItemPickaxe;
import lotr.common.item.LOTRItemPouch;
import lotr.common.item.LOTRItemShovel;
import lotr.common.item.LOTRItemSword;
import lotr.common.item.LOTRItemThrowingAxe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class LOTREnchantmentSoulbound
extends LOTREnchantment {
    private final int level = 1;

    public LOTREnchantmentSoulbound(String s) {
        super(s, new LOTREnchantmentType[]{LOTREnchantmentType.MELEE, LOTREnchantmentType.ARMOR, LOTREnchantmentType.THROWING_AXE, LOTREnchantmentType.RANGED_LAUNCHER});
        this.setBypassAnvilLimit();
        this.setPersistsReforge();
        this.setSoulbound();
    }

    private int getSaves(NBTTagCompound t) {
        return t.func_74762_e("Saves");
    }

    private EnumChatFormatting getColorBySaves(int saves) {
        if (saves == 0) {
            return EnumChatFormatting.RED;
        }
        return EnumChatFormatting.GREEN;
    }

    public static Duration getCooldown(NBTTagCompound t) {
        Instant now = Instant.now();
        if (t.func_74764_b("CD")) {
            long cooldownEnd = t.func_74763_f("CD");
            if (now.toEpochMilli() < cooldownEnd) {
                return Duration.between(now, Instant.ofEpochMilli(cooldownEnd));
            }
        }
        return null;
    }

    private static String formatDuration(Duration duration) {
        long hours = duration.toHours();
        long minutes = duration.toMinutes() % 60L;
        long seconds = duration.getSeconds() % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    @Override
    public String getDescription(ItemStack stack) {
        NBTTagCompound tag;
        String baseDescription = StatCollector.func_74837_a((String)"lotr.enchant.soulbound.desc", (Object[])new Object[0]);
        NBTTagCompound nBTTagCompound = tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        if (tag.func_74764_b("Saves")) {
            int saves = this.getSaves(tag);
            Duration cooldown = LOTREnchantmentSoulbound.getCooldown(tag);
            if (cooldown != null && !cooldown.isZero() && !cooldown.isNegative()) {
                return this.getColorBySaves(saves) + "\u041d\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u043e (\u041f\u0435\u0440\u0435\u0437\u0430\u0440\u044f\u0434\u043a\u0430: " + LOTREnchantmentSoulbound.formatDuration(cooldown) + ")" + EnumChatFormatting.RESET;
            }
            return EnumChatFormatting.GREEN + "\u0410\u043a\u0442\u0438\u0432\u043d\u043e (\u0417\u0430\u0440\u044f\u0436\u0435\u043d)" + EnumChatFormatting.RESET;
        }
        return EnumChatFormatting.GREEN + "\u0410\u043a\u0442\u0438\u0432\u043d\u043e (\u0417\u0430\u0440\u044f\u0436\u0435\u043d)" + EnumChatFormatting.RESET;
    }

    @Override
    public boolean isBeneficial() {
        return true;
    }

    @Override
    public boolean canApply(ItemStack itemstack, boolean considering) {
        ArrayList<Item> validItems = new ArrayList<Item>();
        validItems.add(LOTRMod.sting);
        validItems.add(LOTRMod.ringil);
        validItems.add(LOTRMod.anduril);
        validItems.add(LOTRMod.gandalfStaffGrey);
        validItems.add(LOTRMod.gandalfStaffWhite);
        validItems.add(LOTRMod.gandalfhat);
        validItems.add(LOTRMod.gandalfbody);
        validItems.add(LOTRMod.gandalflegs);
        validItems.add(LOTRMod.gandalfboots);
        validItems.add(LOTRMod.radagasthat);
        validItems.add(LOTRMod.radagastbody);
        validItems.add(LOTRMod.radagastlegs);
        validItems.add(LOTRMod.radagastboots);
        validItems.add(LOTRMod.sarumanhat);
        validItems.add(LOTRMod.sarumanbody);
        validItems.add(LOTRMod.sarumanlegs);
        validItems.add(LOTRMod.sarumanboots);
        validItems.add(LOTRMod.alatarhat);
        validItems.add(LOTRMod.alatarbody);
        validItems.add(LOTRMod.alatarlegs);
        validItems.add(LOTRMod.alatarboots);
        validItems.add(LOTRMod.palandohat);
        validItems.add(LOTRMod.palandobody);
        validItems.add(LOTRMod.palandolegs);
        validItems.add(LOTRMod.palandoboots);
        validItems.add(LOTRMod.glamdring);
        validItems.add(LOTRMod.grond);
        validItems.add(LOTRMod.sauronMace);
        validItems.add(LOTRMod.melkor_sword);
        validItems.add(LOTRMod.battleaxe_melkor);
        validItems.add(LOTRMod.radaghaststaff);
        validItems.add(LOTRMod.sarumanstaff);
        validItems.add(LOTRMod.alatarstaff);
        validItems.add(LOTRMod.pallandostaff);
        validItems.add(LOTRMod.bodyBilbo);
        validItems.add(LOTRMod.d1);
        validItems.add(LOTRMod.d2);
        validItems.add(LOTRMod.d3);
        validItems.add(LOTRMod.d4);
        validItems.add(LOTRMod.d5);
        validItems.add(LOTRMod.d6);
        validItems.add(LOTRMod.d7);
        validItems.add(LOTRMod.naria);
        validItems.add(LOTRMod.nenia);
        validItems.add(LOTRMod.vilia);
        validItems.add(LOTRMod.arcenstone);
        validItems.add(LOTRMod.theOneRing);
        validItems.add(LOTRMod.h1);
        validItems.add(LOTRMod.bundle);
        validItems.add(LOTRMod.ringValarAule);
        validItems.add(LOTRMod.ringValarEste);
        validItems.add(LOTRMod.ringValarIrmo);
        validItems.add(LOTRMod.ringValarManwe);
        validItems.add(LOTRMod.ringValarMelkor);
        validItems.add(LOTRMod.ringValarMelkor1);
        validItems.add(LOTRMod.ringValarNamo);
        validItems.add(LOTRMod.ringValarNessa);
        validItems.add(LOTRMod.ringValarNienna);
        validItems.add(LOTRMod.ringValarOrome);
        validItems.add(LOTRMod.ringValarTulkas);
        validItems.add(LOTRMod.ringValarUlmo);
        validItems.add(LOTRMod.ringValarVaire);
        validItems.add(LOTRMod.ringValarVana);
        validItems.add(LOTRMod.ringValarVarda);
        validItems.add(LOTRMod.ringValarYavanna);
        Item item = itemstack.func_77973_b();
        if (validItems.contains(item)) {
            return true;
        }
        return item instanceof LOTRItemSword || item instanceof LOTRItemArmor || item instanceof LOTRItemBow || item instanceof LOTRItemCrossbow || item instanceof LOTRItemThrowingAxe || item instanceof LOTRItemPickaxe || item instanceof LOTRItemAxe || item instanceof LOTRItemHoe || item instanceof LOTRItemPouch || item instanceof LOTRItemHobbitPipe || item instanceof LOTRItemShovel;
    }
}

